# Poker Tournament Tracker

**[WORK IN PROGRESS]**

Designed and developed from the ground up by **Marshall Evetts**.

---

A comprehensive web-based application for managing home poker tournaments with 18-30 players.

## Features

- **Game Setup**: Configure buy-ins, starting stacks, rebuy rules, and blind structures
- **Player Registration**: Manage player roster, track attendance, and handle walk-ins
- **Chip Configuration**: Flexible chip distribution calculator with validation
- **Live Tournament Timer**: Automatic blind level progression with pause/adjust capabilities
- **Multi-Table Tracking**: Track 2-3 tables with chip leaders and eliminations
- **Rebuy Management**: Track rebuys and calculate prize pool in real-time
- **Game Results**: Final standings and statistics
- **Google Sheets Integration**: Sync game results to your roster database (coming soon)

## Getting Started

### Quick Start (Simplest Method)

1. Extract the poker-tracker folder to your desired location
2. Double-click `index.html` to open in your browser

**Note**: Some features may work better with a local server (see below).

### Running with Local Server (Recommended)

#### Option 1: Python
```bash
cd poker-tracker
python -m http.server 8000
```
Then open http://localhost:8000 in your browser

#### Option 2: Node.js (if you have it installed)
```bash
cd poker-tracker
npx http-server -p 8000
```
Then open http://localhost:8000 in your browser

## Folder Structure

```
poker-tracker/
├── index.html              # Main application file
├── css/
│   └── styles.css          # All styling
├── js/
│   ├── app.js             # Main application logic
│   ├── db.js              # Database operations (IndexedDB)
│   ├── timer.js           # Tournament timer
│   ├── chipCalc.js        # Chip calculator
│   └── sync.js            # Google Sheets sync (placeholder)
├── lib/                    # External libraries (if needed)
└── README.md              # This file
```

## Usage Guide

### 1. Game Setup
- Set the game date (defaults to today)
- Configure buy-in amount
- Set starting stack size
- Configure rebuy rules (if allowing rebuys)
- Choose blind structure (Standard, Deep Stack, or Turbo)

### 2. Player Registration
- Select players from your roster
- Add walk-ins on the fly
- Mark who has paid their buy-in
- System will assign random seating

### 3. Chip Configuration
- Enter your available chip inventory
- Assign chip values (flexible - you decide what each color is worth)
- Set how many chips each player receives
- System validates you have enough chips and correct stack size

### 4. Running the Tournament
- **Timer Tab**: Pause, adjust time, or skip levels
- **Players Tab**: Mark eliminations, view table status
- **Chip Leaders Tab**: Update top 3 or full chip counts
- **Rebuys Tab**: Record rebuys, view prize pool

### 5. Game Results
- View final standings
- See game statistics
- Sync to Google Sheets (when configured)

## Data Storage

All game data is stored locally in your browser using IndexedDB:
- Games persist across browser sessions
- No internet connection required during play
- Data stays on your device

### Backup Your Data

You can export your database for backup:
1. Open browser console (F12)
2. Run: `db.exportToJSON().then(data => console.log(JSON.stringify(data)))`
3. Copy the output and save to a file

## Customization

### Blind Structures
Edit the blind structures in `js/app.js` and `js/timer.js` to match your preferences.

### Chip Denominations
The chip configuration is completely flexible - define any colors, values, and distributions you want.

### Styling
Modify `css/styles.css` to change colors, fonts, or layout.

## Portable Setup

This application is designed to be portable:
1. Copy the entire folder to a USB drive
2. Run from any Windows computer
3. Your data stays in the browser on that computer

For true portability with data, consider:
- Using Chrome/Edge portable versions
- Or implementing the Google Sheets sync for cloud storage

## Android Support (Future)

The app is designed with mobile responsiveness in mind. To use on Android:
1. Host the files on a local network server
2. Access from Android browser
3. Or wrap in Cordova/Capacitor for a native app

## Troubleshooting

**Issue**: Files not loading
- **Solution**: Use a local server instead of opening index.html directly

**Issue**: Data not persisting
- **Solution**: Make sure you're not in private/incognito mode

**Issue**: Can't see previous games
- **Solution**: Must use the same browser on the same computer where games were created

## Future Enhancements

- [ ] Complete Google Sheets integration
- [ ] Export games to PDF
- [ ] Player statistics and leaderboards
- [ ] Custom payout calculator
- [ ] Android app version
- [ ] Multi-device sync
- [ ] TV display mode (cast to large screen)

## Technical Details

- **Frontend**: Vanilla JavaScript (no framework dependencies)
- **Database**: IndexedDB (browser built-in)
- **Storage**: All client-side
- **Requirements**: Modern web browser (Chrome, Edge, Firefox, Safari)

## Support

For issues or questions, refer to the in-app help or check the code comments for implementation details.

## License

This is a personal project for home use. Modify as needed for your games!
